#############################################################
#
# libpng
#
#############################################################
ifneq ($(USE_CVS),true)
LIBPNG_SOURCE:=libpng.tar.gz
LIBPNG_SITE:=ftp://ftp.gnu.org/gnu/libpng
LIBPNG_CAT:=zcat
endif

LIBPNG_DIR:=$(BUILD_DIR)/libpng
LIBPNG_BINARY:=libpng.a
LIBPNG_TARGET_BINARY:=usr/lib/libpng.a

ifneq ($(USE_CVS),true)
libpng-fetch:
	 $(WGET) -P $(DL_DIR) $(LIBPNG_SITE)/$(LIBPNG_SOURCE)

libpng-source: $(DL_DIR)/$(LIBPNG_SOURCE)
else
libpng-source:
endif

LIBPNG_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d libpng $(CVS_TAG) $(CVS_PREFIX)libpng

libpng-checkout:
	@$(LIBPNG_CVSCO)

$(LIBPNG_DIR)/.unpacked: $(DL_DIR)/$(LIBPNG_SOURCE)
ifneq ($(USE_CVS),true)
	$(LIBPNG_CAT) $(DL_DIR)/$(LIBPNG_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LIBPNG_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(LIBPNG_DIR)/
	touch $(LIBPNG_DIR)/.unpacked

$(LIBPNG_DIR)/.configured: $(LIBPNG_DIR)/.unpacked
	(cd $(LIBPNG_DIR); \
		ln -sf scripts/makefile.linux Makefile \
	);
	touch  $(LIBPNG_DIR)/.configured

$(LIBPNG_DIR)/$(LIBPNG_BINARY): $(LIBPNG_DIR)/.configured
	$(MAKE) ZLIBLIB="-I$(STAGING_DIR)/usr/lib" ZLIBINC="-I$(STAGING_DIR)/usr/include" CC=$(TARGET_CC) -C $(LIBPNG_DIR)

$(STAGING_DIR)/$(LIBPNG_TARGET_BINARY): $(LIBPNG_DIR)/$(LIBPNG_BINARY)
	$(MAKE) prefix=$(STAGING_DIR) DESTDIR=$(STAGING_DIR) -C $(LIBPNG_DIR) install
	ln -sf libpng12/png.h $(STAGING_DIR)/usr/include/png.h
	ln -sf libpng12/pngconf.h $(STAGING_DIR)/usr/include/pngconf.h
	install -d $(DOC_DIR)/doc/libpng
	@for f in LICENSE README ; do \
		install -m0644 $(LIBPNG_DIR)/$$f $(DOC_DIR)/doc/libpng/$$f ;\
	done

$(TARGET_DIR)/$(LIBPNG_TARGET_BINARY): $(STAGING_DIR)/$(LIBPNG_TARGET_BINARY)
	$(MAKE) prefix=$(TARGET_DIR) DESTDIR=$(TARGET_DIR) -C $(LIBPNG_DIR) install
	install -d $(DOC_DIR)/doc/libpng
	@for f in LICENSE README ; do \
		install -m0644 $(LIBPNG_DIR)/$$f $(DOC_DIR)/doc/libpng/$$f ;\
	done
	rm -rf $(TARGET_DIR)/include

libpng: uclibc $(TARGET_DIR)/$(LIBPNG_TARGET_BINARY)

libpng-clean:
	-$(MAKE) DESTDIR=$(STAGING_DIR) -C $(LIBPNG_DIR) uninstall
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(LIBPNG_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/libpng
	-$(MAKE) -C $(LIBPNG_DIR) clean

libpng-dirclean:
	rm -rf $(LIBPNG_DIR)

