#############################################################
#
# less
#
#############################################################
ifneq ($(USE_CVS),true)
LESS_SOURCE=less.tar.gz
LESS_SITE=http://www.greenwoodsoftware.com/less
endif

LESS_DIR:=$(BUILD_DIR)/less
LESS_BINARY=less
LESS_TARGET_BINARY=usr/bin/less

ifneq ($(USE_CVS),true)
less-fetch:
	$(WGET) -P $(DL_DIR) $(LESS_SITE)/$(LESS_SOURCE)
endif

LESS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d less $(CVS_TAG) $(CVS_PREFIX)less

less-checkout:
	@$(LESS_CVSCO)

$(LESS_DIR)/.source: $(DL_DIR)/$(LESS_SOURCE)
ifneq ($(USE_CVS),true)
	zcat $(DL_DIR)/$(LESS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LESS_CVSCO)
endif
	touch $(LESS_DIR)/.source

$(LESS_DIR)/.configured: $(LESS_DIR)/.source
	(cd $(LESS_DIR); \
		$(TARGET_CONFIGURE_OPTS) \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--sysconfdir=/etc \
	);
	touch $(LESS_DIR)/.configured;

$(LESS_DIR)/$(LESS_BINARY): $(LESS_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(LESS_DIR)

$(TARGET_DIR)/$(LESS_TARGET_BINARY): $(LESS_DIR)/$(LESS_BINARY)
	$(MAKE) prefix=$(TARGET_DIR)/usr -C $(LESS_DIR) install
	$(STRIP) $(TARGET_DIR)/$(LESS_TARGET_BINARY) \
		$(TARGET_DIR)/usr/bin/lessecho \
		$(TARGET_DIR)/usr/bin/lesskey
	install -d $(DOC_DIR)/doc/less
	for f in LICENSE NEWS ; do \
		install -m0644 $(LESS_DIR)/$$f $(DOC_DIR)/doc/less/$$f ;\
	done

less: uclibc $(TARGET_DIR)/$(LESS_TARGET_BINARY)

less-source: $(DL_DIR)/$(LESS_SOURCE)

less-clean:
	-$(MAKE) prefix=$(TARGET_DIR)/usr -C $(LESS_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/less
	-$(MAKE) -C $(LESS_DIR) clean

less-dirclean:
	rm -rf $(LESS_DIR)

