#############################################################
#
# directfb
#
#############################################################
ifneq ($(USE_CVS),true)
DIRECTFB_SOURCE:=directfb.tar.gz
DIRECTFB_SITE:=xxxxxxxxxxxxxxxxxxxxxxxx
DIRECTFB_CAT:=zcat
endif

DIRECTFB_DIR:=$(BUILD_DIR)/directfb

ifneq ($(USE_CVS),true)
directfb-fetch:
	 $(WGET) -P $(DL_DIR) $(DIRECTFB_SITE)/$(DIRECTFB_SOURCE)

directfb-source: $(DL_DIR)/$(DIRECTFB_SOURCE)
else
directfb-source:
endif

DIRECTFB_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d directfb $(CVS_TAG) $(CVS_PREFIX)directfb

directfb-checkout:
	@$(DIRECTFB_CVSCO)

$(DIRECTFB_DIR)/.unpacked: $(DL_DIR)/$(DIRECTFB_SOURCE)
ifneq ($(USE_CVS),true)
	$(DIRECTFB_CAT) $(DL_DIR)/$(DIRECTFB_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(DIRECTFB_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(DIRECTFB_DIR)/
	touch $(DIRECTFB_DIR)/.unpacked

$(DIRECTFB_DIR)/.configured: $(DIRECTFB_DIR)/.unpacked
	(cd $(DIRECTFB_DIR); rm -rf config.cache; aclocal; automake -a; \
		EGREP=egrep \
		GLIB_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0/include" \
		GLIB_LIBS="-L$(STAGING_DIR)/usr/lib" autoconf; autoheader; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS) -I$(STAGING_DIR)/usr/include -I$(STAGING_DIR)/usr/include/freetype2" \
		LDFLAGS="-L$(STAGING_DIR)/usr/lib" \
		ac_cv_path_FREETYPE_CONFIG=$(STAGING_DIR)/usr/bin/freetype-config \
		lt_cv_prog_cc_pic=' -fPIC -DPIC' \
		lt_cv_prog_cc_can_build_shared=yes \
		lt_cv_prog_cc_no_builtin= \
		lt_cv_prog_cc_shlib= \
		lt_cv_prog_cc_static=-static \
		lt_cv_prog_cc_static_works=yes \
		lt_cv_prog_cc_wl=-Wl, \
		STAGING_DIR=$(STAGING_DIR) \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--with-gfxdrivers=none \
		--disable-sdl \
	);
	touch  $(DIRECTFB_DIR)/.configured

$(DIRECTFB_DIR)/libdirectfb.so: $(DIRECTFB_DIR)/.configured
	$(MAKE) CC_FOR_BUILD=$(HOSTCC)  \
		EGREP=egrep \
		GLIB_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0 -I$(STAGING_DIR)/lib/glib-2.0/include" \
		GLIB_LIBS="-L$(STAGING_DIR)/usr/lib"  \
		FREETYPE_LIBS="-lfontconfig -lfreetype -lxmlparse -lxmltok -lgmodule-2.0 -lgobject-2.0 -lglib-2.0" -C $(DIRECTFB_DIR)

$(STAGING_DIR)/usr/lib/libdirectfb.so: $(DIRECTFB_DIR)/libdirectfb.so
	$(MAKE) \
	    EGREP=egrep \
	    CC_FOR_BUILD=$(HOSTCC)  \
	    DATADIR=$(STAGING_DIR)/usr/share/directfb-0.9.21 \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/directfb \
	    -C $(DIRECTFB_DIR) install-strip;
	chmod a-x $(STAGING_DIR)/usr/lib/libdirectfb*so*
	rm -f $(STAGING_DIR)/usr/lib/libdirect*.la
	rm -f $(STAGING_DIR)/usr/lib/libfusion*.la

$(TARGET_DIR)/usr/lib/libdirectfb.so: $(STAGING_DIR)/usr/lib/libdirectfb.so
	$(MAKE) \
	    EGREP=egrep \
	    GLIB_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0 -I$(STAGING_DIR)/lib/glib-2.0/include" \
	    GLIB_LIBS="-L$(STAGING_DIR)/usr/lib" \
	    CC_FOR_BUILD=$(HOSTCC)  \
	    DATADIR=$(TARGET_DIR)/usr/share/directfb-0.9.21 \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/directfb \
	    -C $(DIRECTFB_DIR) install-strip;
	cp -ar $(STAGING_DIR)/usr/lib/directfb-* $(TARGET_DIR)/usr/lib
	install $(SOURCE_DIR)/directfbrc $(TARGET_DIR)/etc/directfbrc
	chmod a-x $(TARGET_DIR)/usr/lib/libdirectfb*so*
	rm -f $(TARGET_DIR)/usr/lib/libdirect*.la
	rm -f $(TARGET_DIR)/usr/lib/libfusion*.la
	mkdir -p $(DOC_DIR)/doc/directfb
	@for f in COPYING README ; do \
		install -m0644 -D $(DIRECTFB_DIR)/$$f $(DOC_DIR)/doc/directfb/$$f ;\
	done

directfb-clean:
	-$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/directfb \
	    -C $(DIRECTFB_DIR) uninstall
	-$(MAKE)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/directfb \
	    -C $(DIRECTFB_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/directfb
	$(MAKE) -C $(DIRECTFB_DIR) clean


directfb-dirclean:
	rm -rf $(DIRECTFB_DIR)

directfb: uclibc glib glib2 $(TARGET_DIR)/usr/lib/libdirectfb.so


