#############################################################
#
# bzip2
#
#############################################################
ifneq ($(USE_CVS),true)
BZIP2_SOURCE:=bzip2.tar.gz
BZIP2_SITE:=ftp://sources.redhat.com/pub/bzip2/v102
BZIP2_DIR:=$(BUILD_DIR)/${shell basename $(BZIP2_SOURCE) .tar.gz}
BZIP2_CAT:=zcat
else
# using CVS
BZIP2_DIR:=$(BUILD_DIR)/bzip2
endif

BZIP2_BINARY:=bzip2
BZIP2_TARGET_BINARY:=usr/bin/bzmore

#
# bzip2 ignores CFLAGS passed in anyway, so this is pointless
#
BZIP2_COMPILE_FLAGS:=$(TARGET_CONFIGURE_OPTS) CFLAGS="$(TARGET_CFLAGS)"

ifeq ($(strip $(BUILD_WITH_LARGEFILE)),false)
BZIP2_LARGEFILE="--disable-largefile"
endif

ifneq ($(USE_CVS),true)
bzip2-fetch:
	 $(WGET) -P $(DL_DIR) $(BZIP2_SITE)/$(BZIP2_SOURCE)

bzip2-source: $(DL_DIR)/$(BZIP2_SOURCE)
else
bzip2-source:
endif

BZIP2_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d bzip2 $(CVS_TAG) $(CVS_PREFIX)bzip2

bzip2-checkout:
	@$(BZIP2_CVSCO)

$(BZIP2_DIR)/.unpacked: $(DL_DIR)/$(BZIP2_SOURCE)
ifneq ($(USE_CVS),true)
	$(BZIP2_CAT) $(DL_DIR)/$(BZIP2_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(BZIP2_CVSCO)
endif
	sed -i -e "s,ln \$$(,ln -sf \$$(,g" $(BZIP2_DIR)/Makefile
	sed -i -e "s,ln -s (lib.*),ln -sf \$$1 ; ln -sf libbz2.so.1.0.2 libbz2.so,g" \
	    $(BZIP2_DIR)/Makefile-libbz2_so
	touch $(BZIP2_DIR)/.unpacked

$(STAGING_DIR)/lib/libbz2.so.1.0.2: $(BZIP2_DIR)/.unpacked
	$(BZIP2_COMPILE_FLAGS) \
	$(MAKE) CC=$(TARGET_CC) -C $(BZIP2_DIR) -f Makefile-libbz2_so
	$(BZIP2_COMPILE_FLAGS) \
	$(MAKE) CC=$(TARGET_CC) -C $(BZIP2_DIR) libbz2.a
	cp $(BZIP2_DIR)/bzlib.h $(STAGING_DIR)/usr/include/ 
	cp $(BZIP2_DIR)/libbz2.so.1.0.2 $(STAGING_DIR)/lib/ 
	cp $(BZIP2_DIR)/libbz2.a $(STAGING_DIR)/lib/ 
	(cd $(STAGING_DIR)/lib/; ln -sf libbz2.so.1.0.2 libbz2.so) 
	(cd $(STAGING_DIR)/lib/; ln -sf libbz2.so.1.0.2 libbz2.so.1.0) 

$(BZIP2_DIR)/$(BZIP2_BINARY): $(STAGING_DIR)/lib/libbz2.so.1.0.2
	$(BZIP2_COMPILE_FLAGS) \
	$(MAKE) CC=$(TARGET_CC) -C $(BZIP2_DIR) bzip2 bzip2recover

$(TARGET_DIR)/$(BZIP2_TARGET_BINARY): $(BZIP2_DIR)/$(BZIP2_BINARY)
	$(BZIP2_COMPILE_FLAGS) \
	$(MAKE) PREFIX=$(TARGET_DIR)/usr -C $(BZIP2_DIR) install
	rm -f $(TARGET_DIR)/usr/lib/libbz2.a
	rm -f $(TARGET_DIR)/usr/include/bzlib.h
	cp $(BZIP2_DIR)/libbz2.so.1.0.2 $(TARGET_DIR)/usr/lib/
	(cd $(TARGET_DIR)/usr/lib; \
	ln -sf libbz2.so.1.0.2 libbz2.so.1.0; \
	ln -sf libbz2.so.1.0.2 libbz2.so)
	(cd $(TARGET_DIR)/usr/bin; \
	ln -sf bzip2 bunzip2; \
	ln -sf bzip2 bzcat; \
	ln -sf bzdiff bzcmp; \
	ln -sf bzmore bzless; \
	ln -sf bzgrep bzegrep; \
	ln -sf bzgrep bzfgrep;)
	rm -rf $(TARGET_DIR)/share/locale
	$(STRIP) $(TARGET_DIR)/usr/bin/bzip2*
	$(STRIP) $(TARGET_DIR)/usr/lib/libbz2.so.1.0.2
	mkdir -p $(DOC_DIR)/doc/bzip2
	for f in LICENSE README ; do \
	    install -m0644 $(BZIP2_DIR)/$$f $(DOC_DIR)/doc/bzip2/$$f ; \
	done

$(TARGET_DIR)/usr/lib/libbz2.a: $(STAGING_DIR)/lib/libbz2.a
	mkdir -p $(TARGET_DIR)/usr/include 
	cp $(STAGING_DIR)/usr/include/bzlib.h $(TARGET_DIR)/usr/include/
	cp $(STAGING_DIR)/lib/libbz2.a $(TARGET_DIR)/usr/lib/ 
	rm -f $(TARGET_DIR)/lib/libbz2.so
	(cd $(TARGET_DIR)/usr/lib; \
		ln -fs /usr/lib/libbz2.so.1.0 libbz2.so; \
	)
	-$(STRIP) --strip-unneeded $(TARGET_DIR)/usr/lib/libbz2.so.1.0
	touch -c $(TARGET_DIR)/usr/lib/libbz2.a

bzip2-headers: $(TARGET_DIR)/usr/lib/libbz2.a

bzip2: uclibc $(TARGET_DIR)/$(BZIP2_TARGET_BINARY)

bzip2-clean:
	-$(MAKE) -C $(BZIP2_DIR) clean
	-rm -f $(TARGET_DIR)/usr/lib/libbz2*
	-rm -f $(TARGET_DIR)/usr/bin/b*zip2
	-rm -f $(TARGET_DIR)/usr/bin/bzdiff
	-rm -f $(TARGET_DIR)/usr/bin/bzmore
	-rm -f $(TARGET_DIR)/usr/bin/bzless
	-rm -f $(TARGET_DIR)/usr/bin/bz*grep
	-rm -rf $(DOC_DIR)/doc/bzip2

bzip2-dirclean:
	rm -rf $(BZIP2_DIR)

