#############################################################
#
# busybox
#
#############################################################
ifneq ($(USE_CVS),true)
ifeq ($(USE_BUSYBOX_SNAPSHOT),true)
# Be aware that this changes daily....
BUSYBOX_DIR:=$(BUILD_DIR)/busybox
BUSYBOX_SOURCE=busybox-unstable.tar.bz2
BUSYBOX_SITE:=http://www.busybox.net/downloads/snapshots
BUSYBOX_UNZIP=bzcat
BUSYBOX_CONFIG:=$(SOURCE_DIR)/busybox.config
else
BUSYBOX_SOURCE:=busybox.tar.gz
BUSYBOX_DIR:=$(BUILD_DIR)/${shell basename $(BUSYBOX_SOURCE) .tar.gz}
BUSYBOX_SITE:=http://www.busybox.net/downloads
BUSYBOX_UNZIP=zcat
endif
else
# using CVS
BUSYBOX_DIR:=$(BUILD_DIR)/busybox
endif

ifneq ($(USE_CVS),true)
busybox-fetch:
	 $(WGET) -P $(DL_DIR) $(BUSYBOX_SITE)/$(BUSYBOX_SOURCE)

busybox-source: $(DL_DIR)/$(BUSYBOX_SOURCE) $(BUSYBOX_CONFIG)
else
busybox-source:
endif

BUSYBOX_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co $(CVS_TAG) -d busybox $(CVS_PREFIX)busybox 

busybox-checkout:
	@$(BUSYBOX_CVSCO)

$(BUSYBOX_DIR)/.configured: $(DL_DIR)/$(BUSYBOX_SOURCE) $(BUSYBOX_CONFIG)
ifneq ($(USE_CVS),true)
	$(BUSYBOX_UNZIP) $(DL_DIR)/$(BUSYBOX_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(BUSYBOX_CVSCO)
endif
ifeq ($(USE_BUSYBOX_SNAPSHOT),true)
	cp $(BUSYBOX_CONFIG) $(BUSYBOX_DIR)/.config
	sed -i -e "s,^CROSS.*,CROSS=$(TARGET_CROSS)\n\
		PREFIX=$(TARGET_DIR),;" $(BUSYBOX_DIR)/Rules.mak
ifeq ($(strip $(BUILD_WITH_LARGEFILE)),true)
	sed -i -e "s/^.*DOLFS.*/DOLFS=y/;" $(BUSYBOX_DIR)/.config
endif
	$(MAKE) CC=$(TARGET_CC) CROSS="$(TARGET_CROSS)" -C $(BUSYBOX_DIR) oldconfig
else  # Not using snapshot
	sed -i -e "s,^CROSS.*,CROSS=$(TARGET_CROSS),;" $(BUSYBOX_DIR)/Makefile
	sed -i -e "s,^PREFIX.*,PREFIX=$(TARGET_DIR),;" $(BUSYBOX_DIR)/Makefile
ifeq ($(strip $(BUILD_WITH_LARGEFILE)),true)
	sed -i -e "s/^DOLFS.*/DOLFS=true/;" $(BUSYBOX_DIR)/Makefile
endif
endif
	sed -i -e "s/^CFLAGS_EXTRA =.*/CFLAGS_EXTRA = $(TARGET_CFLAGS)/" $(BUSYBOX_DIR)/Makefile
	touch $(BUSYBOX_DIR)/.configured

busybox-unpack: $(BUSYBOX_DIR)/.configured

$(BUSYBOX_DIR)/busybox: $(BUSYBOX_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) CROSS="$(TARGET_CROSS)" PREFIX="$(TARGET_DIR)" \
		-C $(BUSYBOX_DIR)

$(TARGET_DIR)/bin/busybox: $(BUSYBOX_DIR)/busybox
	$(MAKE) CC=$(TARGET_CC) CROSS="$(TARGET_CROSS)" PREFIX="$(TARGET_DIR)" \
		-C $(BUSYBOX_DIR) install
	cp $(BUSYBOX_DIR)/docs/BusyBox.1 $(TARGET_DIR)/usr/man/man1/
	ln -sf BusyBox.1 $(TARGET_DIR)/usr/man/man1/busybox.1
	mkdir -p $(DOC_DIR)/doc/busybox
	@for f in LICENSE README AUTHORS TODO ; do \
	    install -m0644 $(BUSYBOX_DIR)/$$f $(DOC_DIR)/doc/busybox/$$f ;\
	done

busybox: uclibc $(TARGET_DIR)/bin/busybox

busybox-clean:
	#rm -f $(TARGET_DIR)/bin/busybox
	$(MAKE) PREFIX="$(TARGET_DIR)" -C $(BUSYBOX_DIR) uninstall
	-$(MAKE) -C $(BUSYBOX_DIR) clean
	-rm -rf $(DOC_DIR)/doc/busybox
	-rm -f $(TARGET_DIR)/usr/man/man1/BusyBox.1
	-rm -f $(TARGET_DIR)/usr/man/man1/busybox.1

busybox-dirclean:
	rm -rf $(BUSYBOX_DIR)
