// SPDX-License-Identifier: GPL-2.0-only
/*
 * Hardware modules present on the OMAP54xx chips
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com
 *
 * Paul Walmsley
 * Benoit Cousson
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 */

#include <linux/io.h>
#include <linux/power/smartreflex.h>

#include "omap_hwmod.h"
#include "omap_hwmod_common_data.h"
#include "cm1_54xx.h"
#include "cm2_54xx.h"
#include "prm54xx.h"

/* Base offset for all OMAP5 interrupts external to MPUSS */
#define OMAP54XX_IRQ_GIC_START	32

/*
 * IP blocks
 */

/*
 * 'dmm' class
 * instance(s): dmm
 */
static struct omap_hwmod_class omap54xx_dmm_hwmod_class = {
	.name	= "dmm",
};

/* dmm */
static struct omap_hwmod omap54xx_dmm_hwmod = {
	.name		= "dmm",
	.class		= &omap54xx_dmm_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_EMIF_DMM_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_EMIF_DMM_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'l3' class
 * instance(s): l3_instr, l3_main_1, l3_main_2, l3_main_3
 */
static struct omap_hwmod_class omap54xx_l3_hwmod_class = {
	.name	= "l3",
};

/* l3_instr */
static struct omap_hwmod omap54xx_l3_instr_hwmod = {
	.name		= "l3_instr",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INSTR_L3_INSTR_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INSTR_L3_INSTR_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* l3_main_1 */
static struct omap_hwmod omap54xx_l3_main_1_hwmod = {
	.name		= "l3_main_1",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3MAIN1_L3_MAIN_1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3MAIN1_L3_MAIN_1_CONTEXT_OFFSET,
		},
	},
};

/* l3_main_2 */
static struct omap_hwmod omap54xx_l3_main_2_hwmod = {
	.name		= "l3_main_2",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3main2_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3MAIN2_L3_MAIN_2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3MAIN2_L3_MAIN_2_CONTEXT_OFFSET,
		},
	},
};

/* l3_main_3 */
static struct omap_hwmod omap54xx_l3_main_3_hwmod = {
	.name		= "l3_main_3",
	.class		= &omap54xx_l3_hwmod_class,
	.clkdm_name	= "l3instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INSTR_L3_MAIN_3_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INSTR_L3_MAIN_3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'l4' class
 * instance(s): l4_abe, l4_cfg, l4_per, l4_wkup
 */
static struct omap_hwmod_class omap54xx_l4_hwmod_class = {
	.name	= "l4",
};

/* l4_abe */
static struct omap_hwmod omap54xx_l4_abe_hwmod = {
	.name		= "l4_abe",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "abe_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_ABE_L4_ABE_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/* l4_cfg */
static struct omap_hwmod omap54xx_l4_cfg_hwmod = {
	.name		= "l4_cfg",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4CFG_L4_CFG_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4CFG_L4_CFG_CONTEXT_OFFSET,
		},
	},
};

/* l4_per */
static struct omap_hwmod omap54xx_l4_per_hwmod = {
	.name		= "l4_per",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L4PER_L4_PER_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L4PER_L4_PER_CONTEXT_OFFSET,
		},
	},
};

/* l4_wkup */
static struct omap_hwmod omap54xx_l4_wkup_hwmod = {
	.name		= "l4_wkup",
	.class		= &omap54xx_l4_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_WKUPAON_L4_WKUP_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_WKUPAON_L4_WKUP_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'mpu_bus' class
 * instance(s): mpu_private
 */
static struct omap_hwmod_class omap54xx_mpu_bus_hwmod_class = {
	.name	= "mpu_bus",
};

/* mpu_private */
static struct omap_hwmod omap54xx_mpu_private_hwmod = {
	.name		= "mpu_private",
	.class		= &omap54xx_mpu_bus_hwmod_class,
	.clkdm_name	= "mpu_clkdm",
	.prcm = {
		.omap4 = {
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/*
 * 'counter' class
 * 32-bit ordinary counter, clocked by the falling edge of the 32 khz clock
 */

static struct omap_hwmod_class_sysconfig omap54xx_counter_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_counter_hwmod_class = {
	.name	= "counter",
	.sysc	= &omap54xx_counter_sysc,
};

/* counter_32k */
static struct omap_hwmod omap54xx_counter_32k_hwmod = {
	.name		= "counter_32k",
	.class		= &omap54xx_counter_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE,
	.main_clk	= "wkupaon_iclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_WKUPAON_COUNTER_32K_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_WKUPAON_COUNTER_32K_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'emif' class
 * external memory interface no1 (wrapper)
 */

static struct omap_hwmod_class_sysconfig omap54xx_emif_sysc = {
	.rev_offs	= 0x0000,
};

static struct omap_hwmod_class omap54xx_emif_hwmod_class = {
	.name	= "emif",
	.sysc	= &omap54xx_emif_sysc,
};

/* emif1 */
static struct omap_hwmod omap54xx_emif1_hwmod = {
	.name		= "emif1",
	.class		= &omap54xx_emif_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE,
	.main_clk	= "dpll_core_h11x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_EMIF_EMIF1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_EMIF_EMIF1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* emif2 */
static struct omap_hwmod omap54xx_emif2_hwmod = {
	.name		= "emif2",
	.class		= &omap54xx_emif_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE,
	.main_clk	= "dpll_core_h11x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_EMIF_EMIF2_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_EMIF_EMIF2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};




/*
 * 'mpu' class
 * mpu sub-system
 */

static struct omap_hwmod_class omap54xx_mpu_hwmod_class = {
	.name	= "mpu",
};

/* mpu */
static struct omap_hwmod omap54xx_mpu_hwmod = {
	.name		= "mpu",
	.class		= &omap54xx_mpu_hwmod_class,
	.clkdm_name	= "mpu_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE,
	.main_clk	= "dpll_mpu_m2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_MPU_MPU_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_MPU_MPU_CONTEXT_OFFSET,
		},
	},
};


/*
 * 'timer' class
 * general purpose timer module with accurate 1ms tick
 * This class contains several variants: ['timer_1ms', 'timer']
 */

static struct omap_hwmod_class_sysconfig omap54xx_timer_1ms_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_timer_1ms_hwmod_class = {
	.name	= "timer",
	.sysc	= &omap54xx_timer_1ms_sysc,
};

/* timer1 */
static struct omap_hwmod omap54xx_timer1_hwmod = {
	.name		= "timer1",
	.class		= &omap54xx_timer_1ms_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.main_clk	= "timer1_gfclk_mux",
	.flags		= HWMOD_SET_DEFAULT_CLOCKACT,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_WKUPAON_TIMER1_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_WKUPAON_TIMER1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'usb_host_hs' class
 * high-speed multi-port usb host controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_usb_host_hs_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_usb_host_hs_hwmod_class = {
	.name	= "usb_host_hs",
	.sysc	= &omap54xx_usb_host_hs_sysc,
};

static struct omap_hwmod omap54xx_usb_host_hs_hwmod = {
	.name		= "usb_host_hs",
	.class		= &omap54xx_usb_host_hs_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	/*
	 * Errata: USBHOST Configured In Smart-Idle Can Lead To a Deadlock
	 * id: i660
	 *
	 * Description:
	 * In the following configuration :
	 * - USBHOST module is set to smart-idle mode
	 * - PRCM asserts idle_req to the USBHOST module ( This typically
	 *   happens when the system is going to a low power mode : all ports
	 *   have been suspended, the master part of the USBHOST module has
	 *   entered the standby state, and SW has cut the functional clocks)
	 * - an USBHOST interrupt occurs before the module is able to answer
	 *   idle_ack, typically a remote wakeup IRQ.
	 * Then the USB HOST module will enter a deadlock situation where it
	 * is no more accessible nor functional.
	 *
	 * Workaround:
	 * Don't use smart idle; use only force idle, hence HWMOD_SWSUP_SIDLE
	 */

	/*
	 * Errata: USB host EHCI may stall when entering smart-standby mode
	 * Id: i571
	 *
	 * Description:
	 * When the USBHOST module is set to smart-standby mode, and when it is
	 * ready to enter the standby state (i.e. all ports are suspended and
	 * all attached devices are in suspend mode), then it can wrongly assert
	 * the Mstandby signal too early while there are still some residual OCP
	 * transactions ongoing. If this condition occurs, the internal state
	 * machine may go to an undefined state and the USB link may be stuck
	 * upon the next resume.
	 *
	 * Workaround:
	 * Don't use smart standby; use only force standby,
	 * hence HWMOD_SWSUP_MSTANDBY
	 */

	.flags		= HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY,
	.main_clk	= "l3init_60m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_USB_HOST_HS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_USB_HOST_HS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'usb_tll_hs' class
 * usb_tll_hs module is the adapter on the usb_host_hs ports
 */

static struct omap_hwmod_class_sysconfig omap54xx_usb_tll_hs_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class omap54xx_usb_tll_hs_hwmod_class = {
	.name	= "usb_tll_hs",
	.sysc	= &omap54xx_usb_tll_hs_sysc,
};

static struct omap_hwmod omap54xx_usb_tll_hs_hwmod = {
	.name		= "usb_tll_hs",
	.class		= &omap54xx_usb_tll_hs_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "l4_root_clk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_USB_TLL_HS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_USB_TLL_HS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'usb_otg_ss' class
 * 2.0 super speed (usb_otg_ss) controller
 */

static struct omap_hwmod_class_sysconfig omap54xx_usb_otg_ss_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_DMADISABLE | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_usb_otg_ss_hwmod_class = {
	.name	= "usb_otg_ss",
	.sysc	= &omap54xx_usb_otg_ss_sysc,
};

/* usb_otg_ss */
static struct omap_hwmod_opt_clk usb_otg_ss_opt_clks[] = {
	{ .role = "refclk960m", .clk = "usb_otg_ss_refclk960m" },
};

static struct omap_hwmod omap54xx_usb_otg_ss_hwmod = {
	.name		= "usb_otg_ss",
	.class		= &omap54xx_usb_otg_ss_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE,
	.main_clk	= "dpll_core_h13x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_USB_OTG_SS_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_USB_OTG_SS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= usb_otg_ss_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(usb_otg_ss_opt_clks),
};

/*
 * 'sata' class
 * sata:  serial ata interface  gen2 compliant   ( 1 rx/ 1 tx)
 */

static struct omap_hwmod_class_sysconfig omap54xx_sata_sysc = {
	.rev_offs	= 0x00fc,
	.sysc_offs	= 0x0000,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class omap54xx_sata_hwmod_class = {
	.name	= "sata",
	.sysc	= &omap54xx_sata_sysc,
};

/* sata */
static struct omap_hwmod omap54xx_sata_hwmod = {
	.name		= "sata",
	.class		= &omap54xx_sata_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY,
	.main_clk	= "func_48m_fclk",
	.mpu_rt_idx	= 1,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = OMAP54XX_CM_L3INIT_SATA_CLKCTRL_OFFSET,
			.context_offs = OMAP54XX_RM_L3INIT_SATA_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* l4_cfg -> sata */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__sata = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_sata_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/*
 * Interfaces
 */

/* l3_main_1 -> dmm */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__dmm = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_dmm_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_SDMA,
};

/* l3_main_3 -> l3_instr */
static struct omap_hwmod_ocp_if omap54xx_l3_main_3__l3_instr = {
	.master		= &omap54xx_l3_main_3_hwmod,
	.slave		= &omap54xx_l3_instr_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__l3_main_1 = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__l3_main_1 = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> l3_main_1 */
static struct omap_hwmod_ocp_if omap54xx_mpu__l3_main_1 = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_l3_main_1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l3_main_1 -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l3_main_2 = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l4_cfg -> l3_main_2 */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__l3_main_2 = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_l3_main_2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l3_main_3 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l3_main_3 = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l3_main_3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l3_main_2 -> l3_main_3 */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__l3_main_3 = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_l3_main_3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_3 */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__l3_main_3 = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_l3_main_3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_abe */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l4_abe = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l4_abe_hwmod,
	.clk		= "abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> l4_abe */
static struct omap_hwmod_ocp_if omap54xx_mpu__l4_abe = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_l4_abe_hwmod,
	.clk		= "abe_iclk",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_cfg */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l4_cfg = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l4_cfg_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_2 -> l4_per */
static struct omap_hwmod_ocp_if omap54xx_l3_main_2__l4_per = {
	.master		= &omap54xx_l3_main_2_hwmod,
	.slave		= &omap54xx_l4_per_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_wkup */
static struct omap_hwmod_ocp_if omap54xx_l3_main_1__l4_wkup = {
	.master		= &omap54xx_l3_main_1_hwmod,
	.slave		= &omap54xx_l4_wkup_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> mpu_private */
static struct omap_hwmod_ocp_if omap54xx_mpu__mpu_private = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_mpu_private_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> counter_32k */
static struct omap_hwmod_ocp_if omap54xx_l4_wkup__counter_32k = {
	.master		= &omap54xx_l4_wkup_hwmod,
	.slave		= &omap54xx_counter_32k_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> emif1 */
static struct omap_hwmod_ocp_if omap54xx_mpu__emif1 = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_emif1_hwmod,
	.clk		= "dpll_core_h11x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> emif2 */
static struct omap_hwmod_ocp_if omap54xx_mpu__emif2 = {
	.master		= &omap54xx_mpu_hwmod,
	.slave		= &omap54xx_emif2_hwmod,
	.clk		= "dpll_core_h11x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> mpu */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__mpu = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_mpu_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> timer1 */
static struct omap_hwmod_ocp_if omap54xx_l4_wkup__timer1 = {
	.master		= &omap54xx_l4_wkup_hwmod,
	.slave		= &omap54xx_timer1_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> usb_host_hs */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__usb_host_hs = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_usb_host_hs_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> usb_tll_hs */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__usb_tll_hs = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_usb_tll_hs_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> usb_otg_ss */
static struct omap_hwmod_ocp_if omap54xx_l4_cfg__usb_otg_ss = {
	.master		= &omap54xx_l4_cfg_hwmod,
	.slave		= &omap54xx_usb_otg_ss_hwmod,
	.clk		= "dpll_core_h13x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_ocp_if *omap54xx_hwmod_ocp_ifs[] __initdata = {
	&omap54xx_l3_main_1__dmm,
	&omap54xx_l3_main_3__l3_instr,
	&omap54xx_l3_main_2__l3_main_1,
	&omap54xx_l4_cfg__l3_main_1,
	&omap54xx_mpu__l3_main_1,
	&omap54xx_l3_main_1__l3_main_2,
	&omap54xx_l4_cfg__l3_main_2,
	&omap54xx_l3_main_1__l3_main_3,
	&omap54xx_l3_main_2__l3_main_3,
	&omap54xx_l4_cfg__l3_main_3,
	&omap54xx_l3_main_1__l4_abe,
	&omap54xx_mpu__l4_abe,
	&omap54xx_l3_main_1__l4_cfg,
	&omap54xx_l3_main_2__l4_per,
	&omap54xx_l3_main_1__l4_wkup,
	&omap54xx_mpu__mpu_private,
	&omap54xx_l4_wkup__counter_32k,
	&omap54xx_mpu__emif1,
	&omap54xx_mpu__emif2,
	&omap54xx_l4_cfg__mpu,
	&omap54xx_l4_wkup__timer1,
	&omap54xx_l4_cfg__usb_host_hs,
	&omap54xx_l4_cfg__usb_tll_hs,
	&omap54xx_l4_cfg__usb_otg_ss,
	&omap54xx_l4_cfg__sata,
	NULL,
};

int __init omap54xx_hwmod_init(void)
{
	omap_hwmod_init();
	return omap_hwmod_register_links(omap54xx_hwmod_ocp_ifs);
}
