/*
 * stmp378x: LCDIF register definitions
 *
 * Copyright (c) 2008 Freescale Semiconductor
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */
#define REGS_LCDIF_BASE	(STMP3XXX_REGS_BASE + 0x30000)
#define REGS_LCDIF_PHYS	0x80030000
#define REGS_LCDIF_SIZE	0x2000

#define HW_LCDIF_CTRL		0x0
#define BM_LCDIF_CTRL_RUN	0x00000001
#define BP_LCDIF_CTRL_RUN	0
#define BM_LCDIF_CTRL_LCDIF_MASTER	0x00000020
#define BM_LCDIF_CTRL_RGB_TO_YCBCR422_CSC	0x00000080
#define BM_LCDIF_CTRL_WORD_LENGTH	0x00000300
#define BP_LCDIF_CTRL_WORD_LENGTH	8
#define BM_LCDIF_CTRL_LCD_DATABUS_WIDTH	0x00000C00
#define BP_LCDIF_CTRL_LCD_DATABUS_WIDTH	10
#define BM_LCDIF_CTRL_INPUT_DATA_SWIZZLE	0x0000C000
#define BP_LCDIF_CTRL_INPUT_DATA_SWIZZLE	14
#define BM_LCDIF_CTRL_DATA_SELECT	0x00010000
#define BM_LCDIF_CTRL_DOTCLK_MODE	0x00020000
#define BM_LCDIF_CTRL_VSYNC_MODE	0x00040000
#define BM_LCDIF_CTRL_BYPASS_COUNT	0x00080000
#define BM_LCDIF_CTRL_DVI_MODE	0x00100000
#define BM_LCDIF_CTRL_SHIFT_NUM_BITS	0x03E00000
#define BP_LCDIF_CTRL_SHIFT_NUM_BITS	21
#define BM_LCDIF_CTRL_DATA_SHIFT_DIR	0x04000000
#define BM_LCDIF_CTRL_WAIT_FOR_VSYNC_EDGE	0x08000000
#define BM_LCDIF_CTRL_CLKGATE	0x40000000
#define BM_LCDIF_CTRL_SFTRST	0x80000000

#define HW_LCDIF_CTRL1		0x10
#define BM_LCDIF_CTRL1_RESET	0x00000001
#define BP_LCDIF_CTRL1_RESET	0
#define BM_LCDIF_CTRL1_MODE86	0x00000002
#define BM_LCDIF_CTRL1_BUSY_ENABLE	0x00000004
#define BM_LCDIF_CTRL1_VSYNC_EDGE_IRQ	0x00000100
#define BM_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ	0x00000200
#define BM_LCDIF_CTRL1_UNDERFLOW_IRQ	0x00000400
#define BM_LCDIF_CTRL1_OVERFLOW_IRQ	0x00000800
#define BM_LCDIF_CTRL1_VSYNC_EDGE_IRQ_EN	0x00001000
#define BM_LCDIF_CTRL1_BYTE_PACKING_FORMAT	0x000F0000
#define BP_LCDIF_CTRL1_BYTE_PACKING_FORMAT	16
#define BM_LCDIF_CTRL1_INTERLACE_FIELDS	0x00800000
#define BM_LCDIF_CTRL1_RECOVER_ON_UNDERFLOW	0x01000000

#define HW_LCDIF_TRANSFER_COUNT	0x20
#define BM_LCDIF_TRANSFER_COUNT_H_COUNT	0x0000FFFF
#define BP_LCDIF_TRANSFER_COUNT_H_COUNT	0
#define BM_LCDIF_TRANSFER_COUNT_V_COUNT	0xFFFF0000
#define BP_LCDIF_TRANSFER_COUNT_V_COUNT	16

#define HW_LCDIF_CUR_BUF	0x30

#define HW_LCDIF_NEXT_BUF	0x40

#define HW_LCDIF_TIMING		0x60

#define HW_LCDIF_VDCTRL0	0x70
#define BM_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH	0x0003FFFF
#define BP_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH	0
#define BM_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH_UNIT	0x00100000
#define BM_LCDIF_VDCTRL0_VSYNC_PERIOD_UNIT	0x00200000
#define BM_LCDIF_VDCTRL0_ENABLE_POL	0x01000000
#define BM_LCDIF_VDCTRL0_DOTCLK_POL	0x02000000
#define BM_LCDIF_VDCTRL0_HSYNC_POL	0x04000000
#define BM_LCDIF_VDCTRL0_VSYNC_POL	0x08000000
#define BM_LCDIF_VDCTRL0_ENABLE_PRESENT	0x10000000
#define BM_LCDIF_VDCTRL0_VSYNC_OEB	0x20000000

#define HW_LCDIF_VDCTRL1	0x80
#define BM_LCDIF_VDCTRL1_VSYNC_PERIOD	0xFFFFFFFF
#define BP_LCDIF_VDCTRL1_VSYNC_PERIOD	0

#define HW_LCDIF_VDCTRL2	0x90
#define BM_LCDIF_VDCTRL2_HSYNC_PERIOD	0x0003FFFF
#define BP_LCDIF_VDCTRL2_HSYNC_PERIOD	0
#define BM_LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH	0xFF000000
#define BP_LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH	24

#define HW_LCDIF_VDCTRL3	0xA0
#define BM_LCDIF_VDCTRL3_VERTICAL_WAIT_CNT	0x0000FFFF
#define BP_LCDIF_VDCTRL3_VERTICAL_WAIT_CNT	0
#define BM_LCDIF_VDCTRL3_HORIZONTAL_WAIT_CNT	0x0FFF0000
#define BP_LCDIF_VDCTRL3_HORIZONTAL_WAIT_CNT	16

#define HW_LCDIF_VDCTRL4	0xB0
#define BM_LCDIF_VDCTRL4_DOTCLK_H_VALID_DATA_CNT	0x0003FFFF
#define BP_LCDIF_VDCTRL4_DOTCLK_H_VALID_DATA_CNT	0
#define BM_LCDIF_VDCTRL4_SYNC_SIGNALS_ON	0x00040000

#define HW_LCDIF_DVICTRL0	0xC0
#define BM_LCDIF_DVICTRL0_V_LINES_CNT	0x000003FF
#define BP_LCDIF_DVICTRL0_V_LINES_CNT	0
#define BM_LCDIF_DVICTRL0_H_BLANKING_CNT	0x000FFC00
#define BP_LCDIF_DVICTRL0_H_BLANKING_CNT	10
#define BM_LCDIF_DVICTRL0_H_ACTIVE_CNT	0x7FF00000
#define BP_LCDIF_DVICTRL0_H_ACTIVE_CNT	20

#define HW_LCDIF_DVICTRL1	0xD0
#define BM_LCDIF_DVICTRL1_F2_START_LINE	0x000003FF
#define BP_LCDIF_DVICTRL1_F2_START_LINE	0
#define BM_LCDIF_DVICTRL1_F1_END_LINE	0x000FFC00
#define BP_LCDIF_DVICTRL1_F1_END_LINE	10
#define BM_LCDIF_DVICTRL1_F1_START_LINE	0x3FF00000
#define BP_LCDIF_DVICTRL1_F1_START_LINE	20

#define HW_LCDIF_DVICTRL2	0xE0
#define BM_LCDIF_DVICTRL2_V1_BLANK_END_LINE	0x000003FF
#define BP_LCDIF_DVICTRL2_V1_BLANK_END_LINE	0
#define BM_LCDIF_DVICTRL2_V1_BLANK_START_LINE	0x000FFC00
#define BP_LCDIF_DVICTRL2_V1_BLANK_START_LINE	10
#define BM_LCDIF_DVICTRL2_F2_END_LINE	0x3FF00000
#define BP_LCDIF_DVICTRL2_F2_END_LINE	20

#define HW_LCDIF_DVICTRL3	0xF0
#define BM_LCDIF_DVICTRL3_V2_BLANK_END_LINE	0x000003FF
#define BP_LCDIF_DVICTRL3_V2_BLANK_END_LINE	0
#define BM_LCDIF_DVICTRL3_V2_BLANK_START_LINE	0x03FF0000
#define BP_LCDIF_DVICTRL3_V2_BLANK_START_LINE	16

#define HW_LCDIF_DVICTRL4	0x100
#define BM_LCDIF_DVICTRL4_H_FILL_CNT	0x000000FF
#define BP_LCDIF_DVICTRL4_H_FILL_CNT	0
#define BM_LCDIF_DVICTRL4_CR_FILL_VALUE	0x0000FF00
#define BP_LCDIF_DVICTRL4_CR_FILL_VALUE	8
#define BM_LCDIF_DVICTRL4_CB_FILL_VALUE	0x00FF0000
#define BP_LCDIF_DVICTRL4_CB_FILL_VALUE	16
#define BM_LCDIF_DVICTRL4_Y_FILL_VALUE	0xFF000000
#define BP_LCDIF_DVICTRL4_Y_FILL_VALUE	24

#define HW_LCDIF_CSC_COEFF0	0x110
#define BM_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER	0x00000003
#define BP_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER	0
#define BM_LCDIF_CSC_COEFF0_C0	0x03FF0000
#define BP_LCDIF_CSC_COEFF0_C0	16

#define HW_LCDIF_CSC_COEFF1	0x120
#define BM_LCDIF_CSC_COEFF1_C1	0x000003FF
#define BP_LCDIF_CSC_COEFF1_C1	0
#define BM_LCDIF_CSC_COEFF1_C2	0x03FF0000
#define BP_LCDIF_CSC_COEFF1_C2	16

#define HW_LCDIF_CSC_COEFF2	0x130
#define BM_LCDIF_CSC_COEFF2_C3	0x000003FF
#define BP_LCDIF_CSC_COEFF2_C3	0
#define BM_LCDIF_CSC_COEFF2_C4	0x03FF0000
#define BP_LCDIF_CSC_COEFF2_C4	16

#define HW_LCDIF_CSC_COEFF3	0x140
#define BM_LCDIF_CSC_COEFF3_C5	0x000003FF
#define BP_LCDIF_CSC_COEFF3_C5	0
#define BM_LCDIF_CSC_COEFF3_C6	0x03FF0000
#define BP_LCDIF_CSC_COEFF3_C6	16

#define HW_LCDIF_CSC_COEFF4	0x150
#define BM_LCDIF_CSC_COEFF4_C7	0x000003FF
#define BP_LCDIF_CSC_COEFF4_C7	0
#define BM_LCDIF_CSC_COEFF4_C8	0x03FF0000
#define BP_LCDIF_CSC_COEFF4_C8	16

#define HW_LCDIF_CSC_OFFSET	0x160
#define BM_LCDIF_CSC_OFFSET_Y_OFFSET	0x000001FF
#define BP_LCDIF_CSC_OFFSET_Y_OFFSET	0
#define BM_LCDIF_CSC_OFFSET_CBCR_OFFSET	0x01FF0000
#define BP_LCDIF_CSC_OFFSET_CBCR_OFFSET	16

#define HW_LCDIF_CSC_LIMIT	0x170
#define BM_LCDIF_CSC_LIMIT_Y_MAX	0x000000FF
#define BP_LCDIF_CSC_LIMIT_Y_MAX	0
#define BM_LCDIF_CSC_LIMIT_Y_MIN	0x0000FF00
#define BP_LCDIF_CSC_LIMIT_Y_MIN	8
#define BM_LCDIF_CSC_LIMIT_CBCR_MAX	0x00FF0000
#define BP_LCDIF_CSC_LIMIT_CBCR_MAX	16
#define BM_LCDIF_CSC_LIMIT_CBCR_MIN	0xFF000000
#define BP_LCDIF_CSC_LIMIT_CBCR_MIN	24

#define HW_LCDIF_STAT		0x1D0
#define BM_LCDIF_STAT_TXFIFO_EMPTY	0x04000000
