/*======================================================================*/
/*									*/
/*  Immunix CoDomain Module 						*/
/*  Copyright 1998, 1999, 2000 Wirex Communications &			*/
/* 			Oregon Graduate Institute			*/
/*									*/
/*	Written by Steve Beattie <steve@wirex.net>			*/
/*									*/
/*  codomain-x.x.x/CoDomain/codomain_calc_sig.c:			*/
/*									*/
/*======================================================================*/

/* Module versioning code  */
#include <linux/autoconf.h> 		/* Retrieve the CONFIG_* macros */
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
	#define MODVERSIONS 		/* Force it on */
#endif

#ifdef MODVERSIONS
	#include <linux/modversions.h>
#endif

#include <linux/string.h>
#include <linux/dirent.h>

#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/mm.h>
#include <linux/limits.h>
#include <linux/elf.h>

#include <linux/version.h>
#include <linux/module.h>

#include <asm/uaccess.h>

#include <linux/immunix.h>

#undef DEBUG
/* #define DEBUG */


/* Debugging and other syslog macros */
#ifdef DEBUG
        #define dbg(fmt, args...) printk(KERN_DEBUG "Immunix: " fmt "\n" , ## args)
#else
        #define dbg(fmt, args...) do {} while (0)
#endif

#define err(format, arg...) printk(KERN_ERR "Immunix: " format "\n" , ## arg)
#define info(format, arg...) printk(KERN_INFO "Immunix: " format "\n" , ## arg)
#define warn(format, arg...) printk(KERN_WARNING "Immunix: " format "\n" , ## arg)


#include "immunix-md5_version.h"
#include "md5.h"


/*======================================================================*/
/*									*/
/*  init_module: 							*/
/*	Required by module interface. Performs initialization work --  	*/
/*	i.e. registering the table of functions that the module		*/
/*	performs.							*/
/*									*/
/*======================================================================*/

int init_module (void)
{
	printk (KERN_INFO "WireX/Immunix MD5 generation module v"IMMUNIX_MD5_VERSION" initialized.\n");
	return 0;
}

/*======================================================================*/
/*									*/
/*  cleanup_module: 							*/
/* 	Required by Linux module interface. Performs cleanup work -- 	*/
/*	since we're removing the codomain code, we should also free any	*/
/*	existing structures, since nothing will be left to operate on 	*/
/*	them.								*/
/*									*/
/*======================================================================*/

int 
cleanup_module (void)
{
	printk (KERN_INFO "WireX/Immunix MD5 generation module "IMMUNIX_MD5_VERSION" removed.\n");
	return 0;
}


/*======================================================================*/
/*  									*/
/* immunix_compute_elf_sig:						*/
/*  	Computes and returns a digital signature for elf executables.	*/
/*  									*/
/*======================================================================*/

struct immunix_digital_sig * immunix_compute_elf_sig (struct elf_phdr *elf_phdata, int elf_e_phnum, char *name)
{
	struct immunix_digital_sig *sig;
	MD5_CTX ctx;
	int i;
	struct elf_phdr * elf_ppnt;

	dbg (__FUNCTION__ ": %s", name);

	sig = kmalloc (sizeof (struct immunix_digital_sig), GFP_KERNEL);

	if (!sig) {
		warn (__FUNCTION__ ": couldn't allocate memory");
		return NULL;
	}

	MD5Init ( &ctx , 0 ) ;
	for (i = 0, elf_ppnt = elf_phdata; i < elf_e_phnum; i++, elf_ppnt++) {
		if (elf_ppnt->p_type == PT_LOAD) {
			dbg("Found section: addr [%lx] len [%lx]", (unsigned long)elf_ppnt->p_vaddr, (unsigned long)elf_ppnt->p_filesz );
			MD5Update (&ctx , (void *)elf_ppnt->p_vaddr, elf_ppnt->p_filesz, 1);
		}
	}

	MD5Final (sig->md5, &ctx);

#ifdef CONFIG_CODOMAIN_SYSLOG_SPAM
	info ( "md5 %s (pid %d ppid %d uid %d) is: "
	       "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
	       "%02x%02x%02x%02x%02x",
	       name, current->pid,
	       current->p_pptr->pid,
	       current->uid ,
	       sig->md5[0],  sig->md5[1],  sig->md5[2],  sig->md5[3],
	       sig->md5[4],  sig->md5[5],  sig->md5[6],  sig->md5[7],
	       sig->md5[8],  sig->md5[9],  sig->md5[10], sig->md5[11],
	       sig->md5[12], sig->md5[13], sig->md5[14], sig->md5[15]
	       );
#endif /* CONFIG_CODOMAIN_SYSLOG_SPAM */

	return sig;
}

/*======================================================================*/
/*  									*/
/* immunix_compute_script_sig:						*/
/*  	Computes and returns a digital signature for scripts.		*/
/*  									*/
/*======================================================================*/

struct immunix_digital_sig * immunix_compute_script_sig (struct dentry *script_dentry, char *name)
{
	struct immunix_digital_sig * sig;
	MD5_CTX ctx;
	int retval;
	int amount_read = 0;
	int data_to_read = 0;
	unsigned char *script_data = NULL;	/* Kernel space to load a chunk */
						/* of the script into           */

	dbg ("SCRIPT md5 filename: %s inode->i_size %ld "
	     "inode->i_blksize %ld inode->i_blocks %ld dentry_name %s",
	     name,
	     script_dentry->d_inode->i_size,
	     script_dentry->d_inode->i_blksize,
	     script_dentry->d_inode->i_blocks,
	     script_dentry->d_name.name
	     );

	sig = kmalloc (sizeof (struct immunix_digital_sig), GFP_KERNEL);

	if (!sig) {
		warn (__FUNCTION__ ": couldn't allocate memory");
		return NULL;
	}

	script_data = (unsigned char *) __get_free_page (GFP_KERNEL);

	if ( !script_data ) {
		warn (__FUNCTION__ ": couldn't allocate memory");
		kfree (sig);
		return NULL;
	}

	MD5Init (&ctx , 0);

	while (amount_read < script_dentry->d_inode->i_size) {
		data_to_read = ( amount_read + PAGE_SIZE < 
				 script_dentry->d_inode->i_size )
			       ? PAGE_SIZE
			       :(script_dentry->d_inode->i_size - amount_read);

		retval = read_exec (script_dentry, amount_read,
				     script_data, data_to_read, 1);

		if (retval != data_to_read)
			warn ( __FUNCTION__": error doing read_exec: "
				"len: %d retval: %d seek: %d" ,
				data_to_read,
				retval,
				amount_read);

		MD5Update (&ctx, script_data, data_to_read, 0);

		amount_read += data_to_read;
	}

	free_page ((unsigned long)script_data);

	MD5Final (sig->md5, &ctx);

#ifdef CONFIG_CODOMAIN_SYSLOG_SPAM
	info ("SCRIPT md5 %s (pid %d ppid %d uid %d inode->i_size %ld) is: "
	      "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x"
	      "%02x%02x%02x%02x%02x" ,
	      name, current->pid, current->p_pptr->pid,
	      current->uid, script_dentry->d_inode->i_size,
	      sig->md5[0],  sig->md5[1],  sig->md5[2],  sig->md5[3],
	      sig->md5[4],  sig->md5[5],  sig->md5[6],  sig->md5[7],
	      sig->md5[8],  sig->md5[9],  sig->md5[10], sig->md5[11],
	      sig->md5[12], sig->md5[13], sig->md5[14], sig->md5[15]
	      );
#endif /* CONFIG_CODOMAIN_SYSLOG_SPAM */

	return sig;
}



