
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ************************************************************************* */

#include "kxsldbg.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>
#include <version.h>

static const char *description =
    I18N_NOOP("A KDE KPart Application for xsldbg, an XSLT debugger");

static const char *version = KXSLDBG_VERSION;
int main(int argc, char **argv)
{
    KAboutData about("kxsldbg", 0, ki18n("KXSLDbg"), version, ki18n(description), KAboutData::License_GPL, ki18n("(C) 2003 Keith Isdale"), KLocalizedString(), 0, "keith@kdewebdev.org");
    about.addAuthor( ki18n("Keith Isdale"), KLocalizedString(), "keith@kdewebdev.org" );
    KCmdLineArgs::init(argc, argv, &about);

    KCmdLineOptions options;
    options.add("+XSLSource", ki18n("XSL script to run"));
    options.add("+XMLData", ki18n("XML data to be transformed"));
    options.add("+OutputFile", ki18n("File to save results to"));
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;

    // see if we are starting with session management
    if (app.isSessionRestored())
        RESTORE(KXsldbg)
    else
    {
        KXsldbg *widget = new KXsldbg;
        widget->show();
    }

    return app.exec();
}
